// CtrlCard.cpp: implementation of the CCtrlCard class. 
// 
////////////////////////////////////////////////////////////////////// 

# include "stdafx.h" 
# include "DEMO.h" 
# include "CtrlCard.h" 
# include "adt8960.h" 


# ifdef _DEBUG 
# undef THIS_FILE 
   static char THIS_FILE []=__ FILE__; 
# define new DEBUG_NEW 
# endif 

////////////////////////////////////////////////////////////////////// 
// Construction / Destruction 
////////////////////////////////////////////////////////////////////// 

CCtrlCard:: CCtrlCard () 
{ 

} 
/******************* Initialization function ************************ 

    This function includes common control card initialization library function, which is called 
     
    The basis of other functions, it must first call in the example program 
     
    Return value <= 0 initialization failed, return value> 0 indicates a successful initialization 

************************************************** ***/ 
int CCtrlCard:: Init_Board () 
{ 
Result = adt8960_initial (); // card initialization function 

if (Result <= 0) return Result; 
     
    for (int i = 1; i <= MAXAXIS; i++) 
	{ 
        
       set_limit_mode (0, i, 0, 0, 0); // set the limit mode, set the positive and negative limit effective, low effective 
        
       set_command_pos (0, i, 0); // clear logic counter 
        
       set_actual_pos (0, i, 0); // real position counter clear 
        
       set_startv (0, i, 1000); // set the initial speed 
        
       set_speed (0, i, 1000); // set drive speed 

set_acc (0, i, 625); // Set Acceleration 
                          
    } 
     
    return 1; 

}


/********************** Set the speed module *********************** 

    Based on value of the parameter to determine is uniform or accelerated 

Set the initial shaft speed, drive speed and acceleration 

    Parameters: axis - axis No. 

startv - initial velocity 

speed - the speed drive 

          add - Acceleration 
     
    Return value = 0 is correct, return value = 1 error 

************************************************** *******/ 
int CCtrlCard:: Setup_Speed (int axis, long startv, long speed, long add, int mode) 
{ 
if (startv - speed>= 0) // uniform motion 
{ 
Result = set_startv (0, axis, startv); 

set_speed (0, axis, startv); 
} 
else // acceleration 
{ 
if (mode == 0) // trapezoidal acceleration and deceleration when selecting appropriate treatment when 
{ 
set_ad_mode (0, axis, 0); // set the way for the trapezoidal acceleration and deceleration 

Result = set_startv (0, axis, startv); 

set_speed (0, axis, speed); 

set_acc (0, axis, add/125); 
} 
else if (mode == 1) // S curve acceleration and deceleration when selecting appropriate treatment when 
{ 
float time; // time is defined 

float addvar; // acceleration of the rate of change 

long k; // To figure out the results of 

time = (float) (speed-startv) / (add / 2); // the acceleration time 

addvar = add / (time / 2); // acceleration of the rate of change 

k = (long) (1000000/addvar); 

set_ad_mode (0, axis, 1 );//// set the way for the S curve acceleration and deceleration 

set_startv (0, axis, startv); 

set_speed (0, axis, speed); 

set_acc (0, axis, add/125); 

set_acac (0, axis, k); 
} 
} 

return Result; 

} 
/********************* Axis drive functions ********************** 

    The function used to drive a single axis of motion exercise 

    Parameters: axis-axis number, pulse-output pulses 
     
    Return value = 0 is correct, return value = 1 error 

************************************************** *****/ 
int CCtrlCard:: Axis_Pmove (int axis, long pulse) 
{ 
Result = pmove (0, axis, pulse); 

return Result; 

} 


/************************ Uniaxial continuous drive function ******************** *** 

    This function is used to drive a single axis of motion exercise 

    Parameters: axis-axis number, value-pulse direction 
     
    Return value = 0 is correct, return value = 1 error 

************************************************** *********/ 
int CCtrlCard:: Axis_ConMove (int axis, long dir) 
{ 
Result = continue_move (0, axis, dir); 

return Result; 

} 
/******************* Arbitrary two-axis interpolation function ******************** 

    This function is used to drive any two axes motion interpolation 

    Parameters: axis1, axis2-axis number, pulse1, pulse2-pulses 
     
    Return value = 0 is correct, return value = 1 error 

************************************************** *****/ 
int CCtrlCard:: Interp_Move2 (int axis1, int axis2, long pulse1, long pulse2) 
{ 
Result = inp_move2 (0, axis1, axis2, pulse1, pulse2); 

return Result; 

} 
/******************* Arbitrary axis interpolation function ******************** 

    This function is used to drive any axes motion interpolation 

    Parameters: axis1, axis2, axis3-axis number, pulse1, pulse2, pulse3-pulses 
     
    Return value = 0 is correct, return value = 1 error 

************************************************** *****/ 
int CCtrlCard:: Interp_Move3 (int axis1, int axis2, int axis3, long pulse1, long pulse2, long pulse3) 
{ 
Result = inp_move3 (0, axis1, axis2, axis3, pulse1, pulse2, pulse3); 

return Result; 

} 

/******************* Any four-axis interpolation function ************************ **** 

    This function is used to drive for any four-axis interpolation movement 
     
Parameters: axis1, axis2, axis3, axis4-axis No. 

pulse1, pulse2, pulse3, pulse4-output pulses 

    Return value = 0 is correct, return value = 1 error 

************************************************** *********/ 
int CCtrlCard:: Interp_Move4 (int axis1, int axis2, int axis3, int axis4, long pulse1, long pulse2, long pulse3, long pulse4) 
{ 
Result = inp_move4 (0, axis1, axis2, axis3, axis4, pulse1, pulse2, pulse3, pulse4); 

return Result; 
} 


/********************* Arbitrary axis interpolation function ********************** * 

    This function is used to drive an arbitrary axis for interpolation movement 
     
Parameters: axis1, axis2, axis3, axis4, axis5-axis No. 

pulse1, pulse2, pulse3, pulse4, pulse5-output pulses 

    Return value = 0 is correct, return value = 1 error 

************************************************** *********/ 
int CCtrlCard:: Interp_Move5 (int axis1, int axis2, int axis3, int axis4, int axis5, long pulse1, long pulse2, long pulse3, long pulse4, long pulse5) 
{ 
Result = inp_move5 (0, axis1, axis2, axis3, axis4, axis5, pulse1, pulse2, pulse3, pulse4, pulse5); 

return Result; 
} 

/************************* Six-axis interpolation function ******************* *** 

    This function is used to drive six-axis motion interpolation 
     
Parameters: pulse1, pulse2, pulse3, pulse4, pulse5, pulse6-output pulses 

    Return value = 0 is correct, return value = 1 error 

************************************************** *********/ 
int CCtrlCard:: Interp_Move6 (long pulse1, long pulse2, long pulse3, long pulse4, long pulse5, long pulse6) 
{ 
Result = inp_move6 (0, pulse1, pulse2, pulse3, pulse4, pulse5, pulse6); 

return Result; 
} 

/************************ Stop shaft drive ********************** * 

    This function is used to stop immediately or decelerate the drive shaft 

Parameters: axis-axis number, mode-reduction method (0 - stop, 1 - deceleration stop) 
     
    Return value = 0 is correct, return value = 1 error 

************************************************** **********/ 
int CCtrlCard:: StopRun (int axis, int mode) 
{ 
if (mode == 0) // stop 
     
        Result = sudden_stop (0, axis); 
         
    else // deceleration stop 
     
        Result = dec_stop (0, axis); 
         
    return Result; 

} 
 /********************* Access to state  the drive shaft ********************** 

    This function is used to obtain the single-axis drive state or interpolation driving status 

    Parameters: axis-axis number, pulse-status indicator (0 - drive end, non-0 - is driving) 

mode (0 - for uniaxial drive status, 1 - to obtain interpolation drive state) 
     
    Return value = 0 is correct, return value = 1 error 

************************************************** **********/ 
int CCtrlCard:: Get_Status (int axis, int & pulse, int mode) 
{
if (mode == 0) // Get Single-driven state 

Result = get_status (0, axis, & pulse); 

else // Get interpolation driving status 

Result = get_inp_status (0, & pulse); 

return Result; 

} 

/***************** Access to sports information ***************************** * 

    This function is used to feedback the logic of the current axis position, the actual position and speed 

    Parameters: axis-axis number, LogPos-logical position, ActPos-physical location, Speed-speed 
     
    Return value = 0 is correct, return value = 1 error 

************************************************** **********/ 
int CCtrlCard:: Get_CurrentInf (int axis, long & LogPos, long & ActPos, long & Speed) 
{ 
Result = get_command_pos (0, axis, & LogPos); 

get_actual_pos (0, axis, & ActPos); 

get_speed (0, axis, & Speed); 

return Result; 

} 

/*********************** Read input ********************** ********* 

     This function is used to read a single input 

     Parameters: number-input (0 ~ 31) 

     Return value: 0 - low, 1 - high, -1 - Error 

************************************************** **************/ 
int CCtrlCard:: Read_Input (int number) 
{ 
Result = read_bit (0, number); 
     
return Result; 
} 

/********************* Output single-point function ************************ ****** 

    This function is used to output a single point of signal 

    Parameters: number-output point (0 ~ 15), pulse 0 - low, 1 - high 

    Return Value = 0 correct, the return value = 1 error 
************************************************** **************/ 

int CCtrlCard:: Write_Output (int number, int pulse) 
{ 
Result = write_bit (0, number, pulse); 

return Result; 

} 
/******************* Set the location counter *************************** **** 

     This function is used to set the logical location and actual location 

     Parameters: axis-axis number, pos-set position value 
mode 0 - set the logical location, non-0 - set the actual location 

     Return value = 0 is correct, return value = 1 error 
************************************************** **************/ 

int CCtrlCard:: Setup_Pos (int axis, long pos, int mode) 
{ 
if (mode == 0) 
{ 
Result = set_command_pos (0, axis, pos); 
} 
else 
{ 
Result = set_actual_pos (0, axis, pos); 
} 

return Result; 

} 
/******************** Get version information ************************ 
       
This function is used to obtain the hardware version 

Parameters: LibVer-hardware version number 

************************************************** *******/ 
void CCtrlCard:: Get_Version (float & hardVer) 
{ 
// Float Ver; 
hardVer = get_hardware_ver (0); 
// LibVer = float (Ver/256); 
} 
/******************** Set the pulse output mode ********************** 
       
This function is used to set the pulse of the work 

Parameters: axis-axis number, pulse-pulse mode 0 - pulse + pulse mode 1 - Pulse + direction method 

    Return value = 0 is correct, return value = 1 error 

    The default mode for the pulse + direction pulse mode 

    This procedure is the default logic pulse and direction output signals are logic 

************************************************** *******/ 
int CCtrlCard:: Setup_PulseMode (int axis, int pulse) 
{ 
Result = set_pulse_mode (0, axis, pulse, 0, 0); 

return Result; 

} 
/******************** Set limit signaling ********************** 

   This function is used to set the positive / negative direction limit input signal mode nLMT 

   Parameters: axis-axis No. 
          pulse1 0 - is the effective limit 1 - is limit is invalid 
pulse2 0 - negative limit effective 1 - negative limit is invalid 
logic 0 - active LOW 1 - active HIGH 
   The default mode is: is the effective limit the negative limit effective, low effective 

   Return Value = 0 is correct, return value = 1 error 
  ************************************************** *******/ 
int CCtrlCard:: Setup_LimitMode (int axis, int pulse1, int pulse2, int logic) 
{ 
Result = set_limit_mode (0, axis, pulse1, pulse2, logic); 

return Result; 

} 
/******************** Set stop0 signaling ********************** 

   This function is used to set the mode signal stop0 

   Parameters: axis-axis No. 
          pulse 0 - invalid 1 - Effective 
logic 0 - active LOW 1 - active HIGH 
   Default mode: Invalid 

   Return value = 0 is correct, return value = 1 error 
  ************************************************** *******/ 
int CCtrlCard:: Setup_Stop0Mode (int axis, int pulse, int logic) 
{ 
Result = set_stop0_mode (0, axis, pulse, logic); 

return Result; 

} 
/******************** Set stop1 signaling ********************** 

   This function is used to set the mode signal stop1 

   Parameters: axis-axis No. 
          pulse 0 - invalid 1 - Effective 
logic 0 - active LOW 1 - active HIGH 
   Default mode: Invalid 

   Return value = 0 is correct, return value = 1 error 
  ************************************************** *******/ 
int CCtrlCard:: Setup_Stop1Mode (int axis, int pulse, int logic) 
{ 
Result = set_stop1_mode (0, axis, pulse, logic); 

return Result; 

} 

/******************** Set the hardware stop mode ********************** 

   This function is used to set stop signal model of hardware 

   Parameters: pulse 0 - invalid 1 - Effective 
logic 0 - active LOW 1 - active HIGH 
   Default mode: Invalid 

   Return value = 0 is correct, return value = 1 error 

   Hardware terminal stop signal plate 34 fixed to use P3 pin (IN31) 
  ************************************************** *******/ 
int CCtrlCard:: Setup_HardStop (int pulse, int logic) 
{ 
Result = set_suddenstop_mode (0, pulse, logic); 

return Result; 

} 
/******************** Set delay ********************** 

   This function is used to set the delay 

   Parameters: time - delay time (in us) 

   Return value = 0 is correct, return value = 1 error 

  ************************************************** *******/ 
int CCtrlCard:: Setup_Delay (long time) 
{ 
Result = set_delay_time (0, time * 8); 

return Result; 

} 
/******************** For delay status ********************** 

   The state function for delay 

   Return value 0 - delay the end of 1 - Delay in progress 

  ************************************************** *******/ 
int CCtrlCard:: Get_DelayStatus () 
{ 
Result = get_delay_status (0); 

return Result; 
} 

/******************** Set common input and output ********************** 

   This function is used to set the general-purpose input and output 

   Parameters: 
v1-0: 8 points ahead is defined as the input 1: 8 points ahead is defined as the output 

v2-0: 8 points behind the definition of the input 1: 8 points behind is defined as the output 

   Return value = 0 is correct, return value = 1 error 

   Note: When the IO point when used as an output point and can also read input status 
  ************************************************** *******/ 
int CCtrlCard:: Set_IoMode (int v1, int v2) 
{ 
Result = set_io_mode (0, v1, v2); 

return Result; 
} 


/***************************** Axis relative motion **************** ***** 
* Function: reference to the current location, in order to speed up the quantitative movement 
* Parameters: 
      cardno-card number 
No. axis axis --- 
pulse - pulse 
lspd --- slow 
hspd --- High Speed 
      tacc --- speed up the time (unit: seconds) 
vacc --- acceleration rate of change 
mode --- acceleration mode (0: trapezoid, 1: S curve) 
Return value 0: Correct 1: Error 
************************************************** *****************/ 
int CCtrlCard:: Sym_RelativeMove (int axis, long pulse, long lspd, long hspd, double tacc, long vacc, int mode) 
{ 
Result = symmetry_relative_move (0, axis, pulse, lspd, hspd, tacc, vacc, mode); 

    return Result; 
} 

/*************************** Uniaxial absolute Mobile ****************** ****** 
* Function: zero reference position to accelerate the move to quantitative 
* Parameters: 
      cardno-card number 
No. axis axis --- 
pulse - pulse 
lspd --- slow 
hspd --- High Speed 
      tacc --- speed up the time (unit: seconds) 
vacc --- acceleration rate of change 
mode --- acceleration modes (0: trapezoid, 1: S curve) 
Return value 0: Correct 1: Error 
************************************************** ******************/ 
int CCtrlCard:: Sym_AbsoluteMove (int axis, long pulse, long lspd, long hspd, double tacc, long vacc, int mode) 
{ 
Result = symmetry_absolute_move (0, axis, pulse, lspd, hspd, tacc, vacc, mode); 

    return Result; 
} 
/********************** Relative movement of the two-axis linear interpolation ******************** 
* Function: reference to the current location, in order to speed up the linear interpolation 
* Parameters: 
      cardno-card number 
axis1 --- Shaft No. 1 
axis2 --- No. 2 shaft 
pulse1 - Pulse 1 
pulse2 - Pulse 2 
lspd --- slow 
hspd --- High Speed 
      tacc --- speed up the time (unit: seconds) 
vacc --- acceleration rate of change 
mode --- acceleration mode (0: trapezoid, 1: S curve) 
Return value 0: Correct 1: Error 
************************************************** ****************/ 
int CCtrlCard:: Sym_RelativeLine2 (int axis1, int axis2, long pulse1, long pulse2, long lspd, long hspd, double tacc, long vacc, int mode) 
{ 
Result = symmetry_relative_line2 (0, axis1, axis2, pulse1, pulse2, lspd, hspd, tacc, vacc, mode); 

    return Result; 
} 

/******************** Two-axis linear interpolation is absolutely moving ********************** 
* Function: zero reference location to speed up the linear interpolation 
* Parameters: 
      cardno-card number 
axis1 --- Shaft No. 1 
axis2 --- No. 2 shaft 
pulse1 - Pulse 1 
pulse2 - Pulse 2 
lspd --- slow 
hspd --- High Speed 
      tacc --- speed up the time (unit: seconds) 
vacc --- acceleration rate of change 
mode --- acceleration mode (0: trapezoid, 1: S curve) 
Return value 0: Correct 1: Error 
************************************************** ****************/ 
int CCtrlCard:: Sym_AbsoluteLine2 (int axis1, int axis2, long pulse1, long pulse2, long lspd, long hspd, double tacc, long vacc, int mode) 
{ 
Result = symmetry_absolute_line2 (0, axis1, axis2, pulse1, pulse2, lspd, hspd, tacc, vacc, mode); 

    return Result; 
} 

/********************** Three-axis linear interpolation relative motion ******************** 
* Function: reference to the current location, in order to speed up the linear interpolation 
* Parameters: 
      cardno-card number 
axis1 --- Shaft No. 1 
axis2 --- No. 2 shaft 
axis3 --- No. 3 shaft 
pulse1 - Pulse 1 
pulse2 - Pulse 2 
pulse3 - Pulse 3 
lspd --- slow 
hspd --- High Speed 
      tacc --- speed up the time (unit: seconds) 
vacc --- acceleration rate of change 
mode --- acceleration mode (0: trapezoid, 1: S curve) 
Return value 0: Correct 1: Error 
************************************************** ****************/ 
int CCtrlCard:: Sym_RelativeLine3 (int axis1, int axis2, int axis3, long pulse1, long pulse2, long pulse3, long lspd, long hspd, double tacc, long vacc, int mode) 
{ 
Result = symmetry_relative_line3 (0, axis1, axis2, axis3, pulse1, pulse2, pulse3, lspd, hspd, tacc, vacc, mode); 

    return Result; 
} 


/********************* Three-axis linear interpolation of absolute motion ********************* 
Features: zero reference position to speed up the linear interpolation 
Parameters: 
      cardno-card number 
axis1 --- Shaft No. 1 
axis2 --- No. 2 shaft 
axis3 --- No. 3 shaft 
pulse1 - Pulse 1 
pulse2 - Pulse 2 
pulse3 - Pulse 3 
lspd --- slow 
hspd --- High Speed 
      tacc --- speed up the time (unit: seconds) 
vacc --- acceleration rate of change 
mode --- acceleration mode (0: trapezoid, 1: S curve) 
Return value 0: Correct 1: Error 
************************************************** ****************/ 
int CCtrlCard:: Sym_AbsoluteLine3 (int axis1, int axis2, int axis3, long pulse1, long pulse2, long pulse3, long lspd, long hspd, double tacc, long vacc, int mode) 
{ 
Result = symmetry_absolute_line3 (0, axis1, axis2, axis3, pulse1, pulse2, pulse3, lspd, hspd, tacc, vacc, mode); 

    return Result; 
} 

/***************** Four-axis linear interpolation relative motion **************** 
* Function: reference to the current location, in order to speed up the linear interpolation 
* Parameters: 
      cardno-card number 
axis1 --- Shaft No. 1 
axis2 --- No. 2 shaft 
axis3 --- No. 3 shaft 
axis4 --- Shaft No. 4 
pulse1 - Pulse 1 
pulse2 - Pulse 2 
pulse3 - Pulse 3 
pulse4 - Pulse 4 
lspd --- slow 
hspd --- High Speed 
      tacc --- speed up the time (unit: seconds) 
vacc --- acceleration rate of change 
mode --- acceleration mode (0: trapezoid, 1: S curve) 
************************************************** ****/ 
int CCtrlCard:: Sym_RelativeLine4 (int axis1, int axis2, int axis3, int axis4, long pulse1, long pulse2, long pulse3, long pulse4, long lspd, long hspd, double tacc, long vacc, int mode) 
{ 
Result = symmetry_relative_line4 (0, axis1, axis2, axis3, axis4, pulse1, pulse2, pulse3, pulse4, lspd, hspd, tacc, vacc, mode); 
     
return Result; 
} 

 /***************** Four-axis linear interpolation absolute motion **************** 
* Function: zero reference position to accelerate in a straight line interpolation 
* Parameters: 
      cardno-card number 
axis1 --- Shaft No. 1 
axis2 --- No. 2 shaft 
axis3 --- No. 3 shaft 
axis4 --- Shaft No. 4 
pulse1 - Pulse 1 
pulse2 - Pulse 2 
pulse3 - Pulse 3 
pulse4 - Pulse 4 
lspd --- slow 
hspd --- High Speed 
      tacc --- speed up the time (unit: seconds) 
vacc --- acceleration rate of change 
mode --- acceleration mode (0: trapezoid, 1: S curve) 
************************************************** ****/ 
int CCtrlCard:: Sym_AbsoluteLine4 (int axis1, int axis2, int axis3, int axis4, long pulse1, long pulse2, long pulse3, long pulse4, long lspd, long hspd, double tacc, long vacc, int mode) 
{ 
Result = symmetry_absolute_line4 (0, axis1, axis2, axis3, axis4, pulse1, pulse2, pulse3, pulse4, lspd, hspd, tacc, vacc, mode); 

return Result; 
} 

/***************** Axis linear interpolation relative motion **************** 
* Function: reference to the current location, in order to speed up the linear interpolation 
* Parameters: 
      cardno-Card 
axis1 --- Shaft No. 1 
axis2 --- No. 2 shaft 
axis3 --- No. 3 shaft 
axis4 --- Shaft No. 4 
axis5 --- No. 5 shaft 
pulse1 - Pulse 1 
pulse2 - Pulse 2 
pulse3 - Pulse 3 
pulse4 - Pulse 4 
pulse5 - Pulse 5 
lspd --- slow 
hspd --- High Speed 
      tacc --- speed up the time (unit: seconds) 
vacc --- acceleration rate of change 
mode --- acceleration mode (0: ladder, 1: S curve) 
************************************************** ****/ 
int CCtrlCard:: Sym_RelativeLine5 (int axis1, int axis2, int axis3, int axis4, int axis5, long pulse1, long pulse2, long pulse3, long pulse4, long pulse5, long lspd, long hspd, double tacc, long vacc, int mode ) 
{ 
Result = symmetry_relative_line5 (0, axis1, axis2, axis3, axis4, axis5, pulse1, pulse2, pulse3, pulse4, pulse5, lspd, hspd, tacc, vacc, mode); 
     
return Result; 
} 

/***************** Axis linear interpolation of absolute motion **************** 
* Function: zero reference position to accelerate in a straight line interpolation 
* Parameters: 
      cardno-card number 
axis1 --- Shaft No. 1 
axis2 --- No. 2 shaft 
axis3 --- No. 3 shaft 
axis4 --- Shaft No. 4 
axis5 --- No. 5 shaft 
pulse1 - Pulse 1 
pulse2 - Pulse 2 
pulse3 - Pulse 3 
pulse4 - Pulse 4 
      pulse5 - Pulse 5 
lspd --- slow 
hspd --- High Speed 
      tacc --- speed up the time (unit: seconds) 
vacc --- acceleration rate of change 
mode --- acceleration mode (0: trapezoid, 1: S curve) 
************************************************** ****/ 
int CCtrlCard:: Sym_AbsoluteLine5 (int axis1, int axis2, int axis3, int axis4, int axis5, long pulse1, long pulse2, long pulse3, long pulse4, long pulse5, long lspd, long hspd, double tacc, long vacc, int mode ) 
{
Result = symmetry_absolute_line5 (0, axis1, axis2, axis3, axis4, axis5, pulse1, pulse2, pulse3, pulse4, pulse5, lspd, hspd, tacc, vacc, mode); 

return Result; 
} 

/***************** Six-axis linear interpolation relative motion **************** 
* Function: reference to the current location in order to speed up the linear interpolation 
* Parameters: 
      cardno-card number 
pulse1 - Pulse 1 
pulse2 - Pulse 2 
pulse3 - Pulse 3 
pulse4 - Pulse 4 
pulse5 - Pulse 5 
pulse6 - Pulse 6 
lspd --- slow 
hspd --- High Speed 
      tacc --- speed up the time (unit: seconds) 
vacc --- acceleration rate of change 
mode --- acceleration mode (0: trapezoid, 1: S curve) 
************************************************** ****/ 
int CCtrlCard:: Sym_RelativeLine6 (long pulse1, long pulse2, long pulse3, long pulse4, long pulse5, long pulse6, long lspd, long hspd, double tacc, long vacc, int mode) 
{
Result = symmetry_relative_line6 (0, pulse1, pulse2, pulse3, pulse4, pulse5, pulse6, lspd, hspd, tacc, vacc, mode); 
     
return Result; 
} 

/***************** Six-axis linear interpolation of absolute motion **************** 
* Function: zero reference position to accelerate in a straight line interpolation 
* Parameters: 
      cardno-card number 
pulse1 - Pulse 1 
pulse2 - Pulse 2 
pulse3 - Pulse 3 
pulse4 - Pulse 4 
pulse5 - Pulse 5 
pulse6 - Pulse 6 
lspd --- slow 
hspd --- High Speed 
      tacc --- speed up the time (unit: seconds) 
vacc --- acceleration rate of change 
mode --- acceleration mode (0: trapezoid, 1: S curve) 
************************************************** ****/ 
int CCtrlCard:: Sym_AbsoluteLine6 (long pulse1, long pulse2, long pulse3, long pulse4, long pulse5, long pulse6, long lspd, long hspd, double tacc, long vacc, int mode) 
{ 
Result = symmetry_absolute_line6 (0, pulse1, pulse2, pulse3, pulse4, pulse5, pulse6, lspd, hspd, tacc, vacc, mode); 

return Result; 
} 

/******************** For output point ************************** ******* 
Function: Get output point 
Parameters: 
cardno Card 
Output point number 
Return value Returns: the current state of specified port, said parameter error -1 
************************************************** ***/ 
int CCtrlCard:: Get_OutNum (int number) 
{ 
Result = get_out (0, number); 

return Result; 
} 

/************************ Manually driven ********************** quantitative ********** 
Function: Enable manual quantitative-driven features 
Parameters: 
No. axis axis 
pulse pulse 
Return value 0: Correct 1: Error 
************************************************** *********/ 
int CCtrlCard:: Manu_Pmove (int axis, long pulse) 
{ 
Result = manual_pmove (0, axis, pulse); 

return Result; 
} 

/************************ Manual continuous drive ********************** ********** 
Function: Enable manual continuous drive function 
Parameters: 
No. axis axis 
Return value 0: Correct 1: Error 
************************************************** *********/ 
int CCtrlCard:: Manu_Continue (int axis) 
{ 
Result = manual_continue (0, axis); 

return Result; 
} 

/************************ Closed manually driven ********************** ********** 
Function: Close external signal driving 
Parameters: 
No. axis axis 
Return value 0: Correct 1: Error 
************************************************** *********/ 
int CCtrlCard:: Manu_Disable (int axis) 
{
Result = manual_disable (0, axis); 

return Result; 
} 

/**************************** Position latch set function **************** ****** 
Function: Set the signal function in place, lock all the axes of the logical location and actual location 
Parameters: 
axis-reference axis 
mode - Latch mode | 0: Invalid 
| 1: Effective 
regi-counter mode | 0: logical location 
| 1: actual position 
logical-Level Signal | 0: rising edge 
| 1: falling 
Return value 0: Correct 1: Error 
Note: Use the specified axis axis of the IN signal as a trigger signal 
************************************************** *****************/ 
int CCtrlCard:: Setup_LockPosition (int axis, int mode, int regi, int logical) 
{ 
Result = set_lock_position (0, axis, mode, regi, logical); 

return Result; 
} 

/************************* Access latch state ******************** *** 
Function: Get the state of synchronous operation 
Parameters: 
No. axis axis 
v 0 | is not running latch operation 
1 | latch operation performed 
Return value 0: Correct 1: Error 
Description: The position of the latch function can capture whether the implementation of the 
************************************************** ****************/ 
int CCtrlCard:: Get_LockStatus (int axis, int & v) 
{ 
      Result = get_lock_status (0, axis, & v); 

return Result; 
} 

/************************** Get locked position ******************* ******* 
Features: access to the locked position 
Parameters: 
No. axis axis 
latch position pos 
Return value 0: Correct 1: Error 
************************************************** ****************/ 
int CCtrlCard:: Get_LockPosition (int axis, long & pos) 
{
Result = get_lock_position (0, axis, & pos); 

    return Result; 
} 

/************************** Clear latch state ******************* ******* 
Function: Clear latch state 
Parameters: 
No. axis axis (1-4) 
Return value 0: Correct 1: Error 
************************************************** ****************/ 
int CCtrlCard:: Clr_LockPosition (int axis) 
{ 
Result = clr_lock_status (0, axis); 

    return Result; 
}